﻿//INK
// Licence: GPL <http://www.gnu.org/licenses/gpl.html>
//------------------------------------------------------------------------------
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#target photoshop

$._ext_inkUISettings={

	//vars
	initialized : false,

	prefs : [],

	//functions
	init : function() {
		$._ext_inkUISettings.initialized = true;
		$._ext_inkUISettings.prefs       = [];

		$._ext_inkUISettings.prefs.push( { key: "layerDocumentation_printObj" ,
					  					   typeID: app.stringIDToTypeID( "layerDocumentation_printObj" ),
					  					   defValue:"on" } );
		$._ext_inkUISettings.prefs.push( { key: "layerDocumentation_printColor" ,
										   typeID: app.stringIDToTypeID( "layerDocumentation_printColor" ),
										   defValue:"on" } );
		$._ext_inkUISettings.prefs.push( { key: "layerDocumentation_printFx" ,
										   typeID: app.stringIDToTypeID( "layerDocumentation_printFx" ),
										   defValue:"on" } );
		$._ext_inkUISettings.prefs.push( { key: "text_bubble_styling" ,
										   typeID: app.stringIDToTypeID( "text_bubble_styling" ),
										   defValue:"on" } );
		$._ext_inkUISettings.prefs.push( { key: "generate_xml" ,
										   typeID: app.stringIDToTypeID( "generate_xml" ),
										   defValue:"off" } );
		$._ext_inkUISettings.prefs.push( { key: "output_text_color" ,
										   typeID: app.stringIDToTypeID( "output_text_color" ),
										   defValue:"#ffffff" } );
		$._ext_inkUISettings.prefs.push( { key: "measures_color" ,
					  					   typeID: app.stringIDToTypeID( "measures_color" ),
					  					   defValue:"#ff1e07" } );
		$._ext_inkUISettings.prefs.push( { key: "text_bubble_color" ,
										   typeID: app.stringIDToTypeID( "text_bubble_color" ),
										   defValue:"#ff1e07" } );
		$._ext_inkUISettings.prefs.push( { key: "text_size",
										   typeID: app.stringIDToTypeID( "text_size" ),
										   defValue:"10" } );
		$._ext_inkUISettings.prefs.push( { key: "ruler_stroke",
										   typeID: app.stringIDToTypeID( "ruler_stroke" ),
										   defValue:"1" } );
	},

	setSettings : function( userPrefStr ) {

		if ( ! $._ext_inkUISettings.initialized ) {
			$._ext_inkUISettings.init();
		}

		var result        = false;
		var userPrefs     = userPrefStr.split(",");

		try {
			var userPrefsDesc = new ActionDescriptor();
			for ( var i = 0; i < userPrefs.length; i++ ) {
				userPrefsDesc.putString( $._ext_inkUISettings.prefs[i].typeID, userPrefs[i] );
			}
			app.putCustomOptions( "_ink_prefs", userPrefsDesc, true );
			result = true;
		}
		catch(e) {
			result = false;
		}
		return result;
	},

	getSettings : function() {
		if ( ! $._ext_inkUISettings.initialized ) {
			$._ext_inkUISettings.init();
		}

		var settingsOut = "";
		
		try {
			var settingsDesc = app.getCustomOptions( "_ink_prefs" );

			for ( var i = 0; i < $._ext_inkUISettings.prefs.length; i++ ) {
				settingsOut += settingsDesc.getString( $._ext_inkUISettings.prefs[i].typeID );

				if ( i != ( $._ext_inkUISettings.prefs.length - 1 ) ) {
					settingsOut += ",";
				}
			}
		}
		catch(e) {
			//preferences are not registered into photoshop.
			for ( var i = 0; i < $._ext_inkUISettings.prefs.length; i++ ) {
				settingsOut += $._ext_inkUISettings.prefs[i].defValue;

				if ( i != ( $._ext_inkUISettings.prefs.length - 1 ) ) {
					settingsOut += ",";
				}
			}
		}

		return settingsOut;
	},
};

//testing
//$._ext_inkUISettings.getSettings();
//alert( $._ext_inkUISettings.setSettings("off,off,off,off,off,#000000,#000000,#000000,20,2") );